"""This file contains the news schema for the application."""

import re

from pydantic import (
    BaseModel,
    Field,
)


class NewsResponse(BaseModel):
    """Response model for news.

    Attributes:
        id: The unique identifier for the news
        title: Title of the news

        category: category of the news
        abstract: abstract of the news
        body: body of the news
        time: time of the news

    """

    id: str = Field(..., description="The unique identifier for the news")
    title: str = Field(..., description="Title of the news", max_length=128)

    category: str = Field(..., description="category of the news", max_length=128)
    abstract: str = Field(..., description="abstract of the news")
    body: str = Field(..., description="body of the news")
    time: str = Field(..., description="time of the news")
    converted_time: str = Field(..., description="converted time of the news")
