"""This file contains the news model for the application."""

from datetime import (
    UTC,
    datetime,
)

from sqlalchemy import Column, Text
from sqlmodel import Field, SQLModel

from app.models.base import BaseModel


class News(SQLModel, table=True):
    """News model for storing news data.

    Attributes:
        id: The primary key
        created_at: When the news was created
        title: title of news
    """

    id: int = Field(default=None, primary_key=True)
    title: str = Field(default="")
    category: str = Field(default="")
    abstract: str = Field(default="")
    body: str = Field(sa_column=Column(Text))
    time: str = Field(default="")
    converted_time: datetime = Field(default_factory=lambda: datetime.now(UTC))

    created_at: datetime = Field(default_factory=lambda: datetime.now(UTC))
