"""This file contains the map model for the application."""

from datetime import (
    UTC,
    datetime,
)
from typing import List

from sqlalchemy import JSON, Column, Text
from sqlmodel import Field, SQLModel


class Map(SQLModel, table=True):
    """Map model for storing map data.

    Attributes:
        id: The primary key
        created_at: When the news was created
        province: name of province
    """

    id: int = Field(default=None, primary_key=True)
    province: str = Field(nullable=False)
    active_user: int = Field(default=0)
    related_news: int = Field(default=0)
    tags: List[str] = Field(default_factory=list, sa_column=Column(JSON))
    agent_analysis: str = Field(sa_column=Column(Text))

    created_at: datetime = Field(default_factory=lambda: datetime.now(UTC), nullable=False)
