"""This file contains the accident model for the application."""

from datetime import (
    UTC,
    datetime,
)
from typing import List

from sqlalchemy import JSON, Column, Text
from sqlmodel import Field, SQLModel


class Accident(SQLModel, table=True):
    """Accident model for storing accident data.

    Attributes:
        id: The primary key
        year: year of accident
        leading_to_death: accidents which leads to death
        lead_to_injury: accidents which leads to injury
        lead_to_damage: accidents which leads to damage
    """

    id: int = Field(default=None, primary_key=True)

    year: int = Field(default=1300)
    all_accident: int = Field(default=0)
    leading_to_death: int = Field(default=0)
    lead_to_injury: int = Field(default=0)
    lead_to_damage: int = Field(default=0)

    created_at: datetime = Field(default_factory=lambda: datetime.now(UTC), nullable=False)
