"""Prompts."""

# from langchain_core.prompts import ChatPromptTemplate
from langchain_core.prompts import PromptTemplate
from transformers import RagPreTrainedModel


def analysis_rag_prompt():
    """Rag prompt."""
    template = """You are a domain-expert Iranian assistant trained by the Iranian Ministry of Analysis to answer questions about Iran provinces data.
You should generate well-written, factual and complete answers in Persian. If the question's answer not existed in context, politely explain the out-of-bound question to the user.
If the user start conversation without any DSL questions, answer them friendly and chat with them, and explain your task about answering question.
Answer the following question based on this context:

{context}

Question: {question}
"""
    # prompt = ChatPromptTemplate.from_template(template)
    rag_prompt = PromptTemplate(input_variables=["context", "question"], template=template)

    return rag_prompt
